package ru.yandex.chemodan.app.docviewer.utils;

import java.util.Collection;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.tsb.YandexStandardToStringStyle;
import ru.yandex.misc.lang.tsb.YandexToStringBuilder;

/**
 * TODO trim long arrays
 * @author ssytnik
 */
public class ReflectionUtils2 {

    public static String reflectionToStringValueObject(Object o) {
        return reflectionToStringValueObject(o, Option.empty());
    }

    public static String reflectionToStringValueObject(Object o, int maxDepth) {
        return reflectionToStringValueObject(o, Option.of(maxDepth));
    }

    /**
     * @see YandexToStringBuilder#reflectionToStringValueObject(Object)
     */
    public static String reflectionToStringValueObject(Object o, Option<Integer> maxDepth) {
        DeepYandexToStringStyle style = new DeepYandexToStringStyle(maxDepth);
        style.setUseIdentityHashCode(false);
        return reflectionToStringValueObject(o, style);
    }



    private static String reflectionToStringValueObject(Object o, DeepYandexToStringStyle style) {
        return new YandexToStringBuilder(o, style).toString();
    }

    /**
     * this is a slightly modified version of http://stackoverflow.com/a/3514475
     */
    @SuppressWarnings("serial")
    private static class DeepYandexToStringStyle extends YandexStandardToStringStyle {

        {
            setArraySeparator(getFieldSeparator());
        }

        /**
         * 0: first level only; 1: up to second level, etc. None: all levels
         */
        private Option<Integer> maxDepth;

        private int depth;

        public DeepYandexToStringStyle(Option<Integer> maxDepth) {
            this.maxDepth = maxDepth;
        }

        /**
         * Can't override {@link #appendInternal(StringBuffer, String, Object, boolean)}
         * due to non-visible cyclic reference check. Other appendDetail methods,
         * including ones with primitive arrays and maps, can be treated one-level ones.
         *
         * Note that bottom-level objects ignore settings like useClassName
         * because they are added as values (with {@link #toString()} possibly overridden).
         */
        @Override
        protected void appendDetail(StringBuffer buffer, String fieldName, Object value) {
            if (value.getClass().getName().startsWith("java.lang.") || maxDepth.isPresent() && depth >= maxDepth.get()) {
                buffer.append(value);
            } else {
                depth++;
                buffer.append(reflectionToStringValueObject(value, this));
                depth--;
            }
        }


        @SuppressWarnings("rawtypes")
        @Override
        protected void appendDetail(StringBuffer buffer, String fieldName, Collection/*<?>*/ coll) {
             depth++;
             appendContentStart(buffer);
             boolean first = true;
             for (Object value : coll) {
                 if (first) {
                     first = false;
                 } else {
                     buffer.append(getArraySeparator());
                 }
                 appendDetail(buffer, "", value);
             }
             appendContentEnd(buffer);
             depth--;
        }

    }

}
