package ru.yandex.chemodan.app.docviewer.utils;

import java.net.MalformedURLException;
import java.net.URI;

@SuppressWarnings("serial")
public class RuntimeMalformedURLException extends RuntimeException {

    private final String url;

    public RuntimeMalformedURLException(String url, MalformedURLException source) {
        super("Unable to convert string '" + url + "' to URL: " + source, source);

        this.url = url;
    }

    public RuntimeMalformedURLException(URI uri, Exception source) {
        super("Unable to convert URI '" + uri + "' to URL: " + source, source);

        this.url = uri.toString();
    }

    public String getUrl() {
        return url;
    }
}
