package ru.yandex.chemodan.app.docviewer.utils;

import java.net.URISyntaxException;
import java.net.URL;

@SuppressWarnings("serial")
public class RuntimeURISyntaxException extends RuntimeException {

    private final String uri;

    public RuntimeURISyntaxException(String uri, URISyntaxException source) {
        super("Unable to convert string '" + uri + "' to URI: " + source, source);

        this.uri = uri;
    }

    public RuntimeURISyntaxException(URL url, URISyntaxException source) {
        super("Unable to convert URL '" + url + "' to URI: " + source, source);

        this.uri = url.toString();
    }

    public String getUri() {
        return uri;
    }
}
