package ru.yandex.chemodan.app.docviewer.utils;

import java.io.BufferedOutputStream;
import java.io.OutputStream;

import org.dom4j.io.OutputFormat;

import ru.yandex.misc.io.IoFunction1V;
import ru.yandex.misc.io.OutputStreamSource;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

public class XmlSerializer {

    public void serializeToXml(final org.dom4j.Document doc, final OutputStream outputStream) {
        Dom4jUtils.write(doc, outputStream, getOutputFormat(false));
    }

    public String serializeToXml(final org.dom4j.Document doc) {
        return new String(Dom4jUtils.write(doc, getOutputFormat(true)));
    }

    public static OutputFormat getOutputFormat(boolean suppressDeclaration) {
        OutputFormat outputFormat = OutputFormat.createCompactFormat();
        outputFormat.setEncoding("utf-8");
        outputFormat.setExpandEmptyElements(false);
        outputFormat.setIndent(false);
        outputFormat.setNewLineAfterDeclaration(true);
        outputFormat.setTrimText(false);
        outputFormat.setSuppressDeclaration(suppressDeclaration);
        return outputFormat;
    }

    public void serializeToXml(final org.dom4j.Document doc,
            final OutputStreamSource outputStreamSource)
    {
        outputStreamSource.writeBuffered((IoFunction1V<BufferedOutputStream>) outputStream -> {
            serializeToXml(doc, outputStream);
        });
    }
}
