package ru.yandex.chemodan.app.docviewer.utils;

import java.util.Map;

import org.cyberneko.html.parsers.DOMParser;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.w3c.dom.Document;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.docviewer.convert.DocumentProperties;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.ReaderSource;
import ru.yandex.misc.xml.InputSourceCallback;
import ru.yandex.misc.xml.XmlUtils;

public class XmlUtils2 extends XmlUtils {

    public static org.dom4j.Document convertToDom4j(org.w3c.dom.Document document) {
        DOMReader domReader = new DOMReader();
        return domReader.read(document);
    }

    public static org.w3c.dom.Document parseHtmlToDom(InputStreamSource inputStreamSource) {
        return XmlUtils.read(inputStreamSource, (InputSourceCallback<Document>) inputSource -> {
            DOMParser domParser = new DOMParser();
            domParser.parse(inputSource);
            return domParser.getDocument();
        });
    }

    public static org.w3c.dom.Document parseHtmlToDom(ReaderSource readerSource) {
        return XmlUtils.read(readerSource, (InputSourceCallback<Document>) inputSource -> {
            DOMParser domParser = new DOMParser();
            domParser.parse(inputSource);
            return domParser.getDocument();
        });
    }

    public static org.dom4j.Document parseHtmlToDom4j(InputStreamSource source) {
        return convertToDom4j(parseHtmlToDom(source));
    }

    public static org.dom4j.Document parseHtmlToDom4j(ReaderSource source) {
        return convertToDom4j(parseHtmlToDom(source));
    }


    public static void appendProperties(Element element, DocumentProperties properties) {
        for (Map.Entry<String, String> entry : properties.get().entrySet()) {
            String propName = entry.getKey();
            String propValue = entry.getValue();
            element.addElement(propName).addText(propValue);
        }
    }

    // TODO use XmlUtils.invalidCharsToSpaces
    // http://www.w3.org/TR/xml/#charsets
    public static String stripInvalidXmlCharacters(String value) {
        if (value == null) {
            return null;
        }

        StringBuilder sb = new StringBuilder(value.length());
        for (char c : value.toCharArray()) {
            // what's about 0x10000+ ?
            if (c == 0x9 || c == 0xA || c == 0xD || (c >= 0x20 && c <= 0xD7FF) || (c >= 0xE000 && c <= 0xFFFD)) {
                sb.append(c);
            }
        }
        return sb.toString();
    }


    public static Function<Node, String> getTextF() {
        return Node::getText;
    }

    public static Function<Element, String> attributeValueF(final String name) {
        return a -> a.attributeValue(name);
    }

}
