package ru.yandex.chemodan.app.docviewer.utils;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;

/**
 * @author ssytnik
 */
public class XslUtils {

    private static final TransformerFactory FACTORY = TransformerFactory.newInstance();
    private static final MapF<String, Transformer> TRANSFORMERS = Cf.concurrentHashMap();


    public static Transformer getTransformer(final Class<?> clazz, final String xslRelPath) {
        return TRANSFORMERS.getOrElseUpdate(clazz.getName() + "." + xslRelPath, () -> {
            ClassPathResourceInputStreamSource iss = new ClassPathResourceInputStreamSource(clazz, xslRelPath);
            return iss.readX(a -> {
                try {
                    return FACTORY.newTransformer(new StreamSource(a));
                } catch (TransformerConfigurationException e) {
                    throw ExceptionUtils.translate(e);
                }
            });
        });
    }

    public static Document transform(Transformer transformer, Document document) {
        try {
            DocumentSource source = new DocumentSource( document );
            DocumentResult result = new DocumentResult();
            transformer.transform( source, result );
            return result.getDocument();
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
    }

}
