package ru.yandex.chemodan.app.docviewer.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.lang.Validate;

/**
 * @author vlsergey
 * @author ssytnik
 */
public class ZipEntryInputStreamSource extends InputStreamSource {

    private final ZipEntry zipEntry;
    private final ZipFile zipFile;


    public ZipEntryInputStreamSource(ZipFile zipFile, String zipEntryName) {
        this(zipFile, zipFile.getEntry(zipEntryName));
        Validate.notNull(this.zipEntry, "Entry not found: " + zipEntryName);
    }

    public ZipEntryInputStreamSource(ZipFile zipFile, ZipEntry zipEntry) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
    }

    @Override
    public InputStream getInput() throws IOException {
        return zipFile.getInputStream(zipEntry);
    }

}
