package ru.yandex.chemodan.app.docviewer.utils.cache;

import org.apache.commons.lang3.Validate;
import org.joda.time.Instant;

import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.time.TimeUtils;

/**
 * @author akirakozov
 */
public class TempFileItem {
    // Store file size in memmory for performance reason (DOCVIEWER-1389)
    private final long fileSize;
    private final File2 file;
    private Instant lastUsage;

    public TempFileItem(File2 file) {
        Validate.notNull(file);
        Validate.isTrue(file.length() > 0);
        this.file = file;
        this.fileSize = file.length();
        lastUsage = TimeUtils.now();
    }

    public void updateLastUsage() {
        lastUsage = TimeUtils.now();
    }

    public Instant getLastUsage() {
        return lastUsage;
    }

    public File2 getFile() {
        return file;
    }

    public long getFileSize() {
        return fileSize;
    }
}
