package ru.yandex.chemodan.app.docviewer.utils.html;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;

public abstract class AbstractDom4jVisitor {

    @SuppressWarnings("unused")
    protected void visit(Attribute node) {
        // no default impl
    }

    @SuppressWarnings("unused")
    protected void visit(CDATA node) {
        // no default impl
    }

    @SuppressWarnings("unused")
    protected void visit(Comment node) {
        // no default impl
    }

    public final void visit(Document document) {
        visitR(document.getRootElement());
    }

    @SuppressWarnings("unused")
    protected void visit(DocumentType node) {
        // no default impl
    }

    @SuppressWarnings("unused")
    protected void visit(Element element) {
        // no default impl
    }

    @SuppressWarnings("unused")
    protected void visit(Entity entity) {
        // no default impl
    }

    @SuppressWarnings("unused")
    protected void visit(ProcessingInstruction node) {
        // no default impl
    }

    @SuppressWarnings("unused")
    protected void visit(Text node) {
        // no default impl
    }

    private void visitImpl(Node node) {
        switch (node.getNodeType()) {
            case Node.ATTRIBUTE_NODE:
                visit((Attribute) node);
                break;
            case Node.CDATA_SECTION_NODE:
                visit((CDATA) node);
                break;
            case Node.COMMENT_NODE:
                visit((Comment) node);
                break;
            case Node.DOCUMENT_NODE:
                visit((Document) node);
                break;
            case Node.DOCUMENT_TYPE_NODE:
                visit((DocumentType) node);
                break;
            case Node.ELEMENT_NODE:
                visit((Element) node);
                break;
            case Node.ENTITY_REFERENCE_NODE:
                visit((Entity) node);
                break;
            case Node.PROCESSING_INSTRUCTION_NODE:
                visit((ProcessingInstruction) node);
                break;
            case Node.TEXT_NODE:
                visit((Text) node);
                break;
            default:
                visitUnknown(node);
                break;
        }
    }

    private void visitR(Node node) {
        if (node instanceof Branch) {
            Branch branch = (Branch) node;
            List<Node> children = new ArrayList<Node>(branch.content());
            for (Node child : children) {
                visitImpl(child);
                visitR(child);
            }
        }
    }

    @SuppressWarnings("unused")
    protected void visitUnknown(Node node) {
        // no default impl
    }
}
