package ru.yandex.chemodan.app.docviewer.utils.html;

import java.util.Map;
import java.util.TreeMap;

import org.apache.poi.hwpf.converter.HtmlDocumentFacade;
import org.w3c.dom.Document;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;

/**
 * Normally css class written by html document facade is as follows:<br/>
 * &lt;dot&gt; &lt;className&gt;<br/>
 *
 * Sometimes, there is a need to use addition other than dot,
 * depending on a className prefix. This extension allows it.<br/>
 *
 * Also, it supports {@literal @}font-face.
 *
 * @author ssytnik
 */
public class HtmlDocumentExtCssFacade extends HtmlDocumentFacade {

    /** if css class starts with a prefix, then use addition instead of "." */
    private final Map<String, String> prefix2addition;

    private MapF<String, String> fontFaceIdToCssStyle = Cf.x(new TreeMap<>());


    public HtmlDocumentExtCssFacade(Document document) {
        this(document, Cf.map());
    }

    public HtmlDocumentExtCssFacade(Document document, Map<String, String> prefix2addition) {
        super(document);
        this.prefix2addition = prefix2addition;
    }

    public void addFontFace(String fontFaceId, String fontFaceCssStyle) {
        if (!fontFaceIdToCssStyle.containsKeyTs(fontFaceId)) {
            fontFaceIdToCssStyle.put(fontFaceId, fontFaceCssStyle);
        }
    }

    protected String buildStylesheet(final Map<String, Map<String, String>> prefixToMapOfStyles)
    {
        StringBuilder stringBuilder = new StringBuilder();

        for (String fontFaceCssStyle : fontFaceIdToCssStyle.values()) {
            stringBuilder.append( "@font-face {" );
            stringBuilder.append( fontFaceCssStyle );
            stringBuilder.append( "}\n" );
        }

        for (Map<String, String> byPrefix : prefixToMapOfStyles.values()) {
            for (Map.Entry<String, String> byStyle : byPrefix.entrySet()) {
                String style = byStyle.getKey();
                String className = byStyle.getValue();

                String addition = ".";
                for (Map.Entry<String, String> e : prefix2addition.entrySet()) {
                    if (className.startsWith(e.getKey())) {
                        addition = e.getValue();
                        break;
                    }
                }
                stringBuilder.append( addition );
                stringBuilder.append( className );
                stringBuilder.append( "{" );
                stringBuilder.append( style );
                stringBuilder.append( "}\n" );
            }
        }
        return stringBuilder.toString();
    }

}
