package ru.yandex.chemodan.app.docviewer.utils.html;

import org.dom4j.Element;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author vlsergey
 * @author akirakozov
 */
class HtmlMinWidthProcessor extends AbstractDom4jVisitor {

    public static final String BODY_CHILD_ATTRIBUTE_WIDTH = "x-width";

    private float updateMinWidth(float originalMinWidth, Element child) {
        String widthString = child.attributeValue(BODY_CHILD_ATTRIBUTE_WIDTH);
        Option<Float> value = Cf.Float.parseSafe(widthString);
        if (value.isPresent()) {
            child.remove(child.attribute(BODY_CHILD_ATTRIBUTE_WIDTH));
            return Math.max(originalMinWidth, value.get());
        } else {
            return originalMinWidth;
        }
    }

    @Override
    protected void visit(Element element) {
        if (StringUtils.equalsIgnoreCase("BODY", element.getName())) {
            if (element.attribute("min-width") != null)
                return;

            float minWidth = 0;

            for (Element child : HtmlUtils.findChildElements(element, "DIV")) {
                minWidth = updateMinWidth(minWidth, child);
            }
            for (Element child : HtmlUtils.findChildElements(element, "TABLE")) {
                minWidth = updateMinWidth(minWidth, child);
            }

            if (minWidth != 0f) {
                element.addAttribute("min-width", Integer.toString(Math.round(minWidth)));
            }
        }
    }
}
