package ru.yandex.chemodan.app.docviewer.utils.html;

import java.io.IOException;
import java.io.OutputStream;

import org.dom4j.Document;
import org.dom4j.io.HTMLWriter;
import org.dom4j.io.OutputFormat;

import ru.yandex.chemodan.app.docviewer.utils.XmlSerializer;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.IoFunction1V;

public class HtmlSerializer {

    private static final OutputFormat format = XmlSerializer.getOutputFormat(false);

    public void serializeToHtml(final Document doc, final OutputStream outputStream) {
        try {
            HTMLWriter writer = new HTMLWriter(outputStream, format);
            writer.write(doc);
            writer.flush();
        } catch (IOException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    public <T extends OutputStream> IoFunction1V<T> serializeToHtmlHandler(Document doc) {
        return outputStream -> serializeToHtml(doc, outputStream);
    }
}
