package ru.yandex.chemodan.app.docviewer.utils.html;

import java.util.List;

import org.dom4j.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.StringUtils;

class HtmlTablesWidthProcessor extends AbstractDom4jVisitor {

    private static final Float MAX_WIDTH = 900f;
    private static final String WIDTH = "width";

    @Override
    protected void visit(Element element) {
        if (element.attribute(HtmlMinWidthProcessor.BODY_CHILD_ATTRIBUTE_WIDTH) != null)
            return;

        if (StringUtils.equalsIgnoreCase("DIV", element.getName())) {
            if (element.attribute(WIDTH) != null) {
                element.addAttribute(HtmlMinWidthProcessor.BODY_CHILD_ATTRIBUTE_WIDTH,
                        element.attributeValue(WIDTH));
                return;
            }
        }

        if (StringUtils.equalsIgnoreCase("TABLE", element.getName())) {
            if (element.attribute(WIDTH) != null) {
                element.addAttribute(HtmlMinWidthProcessor.BODY_CHILD_ATTRIBUTE_WIDTH,
                        element.attributeValue(WIDTH));
                process(findCols(element));
                return;
            }

            Option<Element> colgroup = HtmlUtils.findChildElement(element, "COLGROUP");
            if (colgroup.isPresent()) {
                double totalWidth = process(findCols(colgroup.get()));
                if (totalWidth > 1) {
                    element.addAttribute(HtmlMinWidthProcessor.BODY_CHILD_ATTRIBUTE_WIDTH, Double.toString(totalWidth));
                }
            }
        }
        super.visit(element);
    }

    private List<Element> findCols(Element element) {
        return HtmlUtils.findChildElements(element, "COL");
    }

    private double process(List<Element> elements) {
        return elements.stream().filter(e -> !StringUtils.isEmpty(e.attributeValue(WIDTH)))
                .mapToDouble(col -> {
            try {
                Double value = Double.valueOf(col.attributeValue(WIDTH));
                if (value > MAX_WIDTH) {
                    col.remove(col.attribute(WIDTH));
                    return 0;
                }
                return value;
            } catch (NumberFormatException exc) {
                // ignore
                return 0;
            }
        }).sum();
    }
}
