package ru.yandex.chemodan.app.docviewer.utils.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.dom4j.Document;
import org.dom4j.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.lang.Validate;

class HtmlUtils {

    static final Set<String> ATTRIBUTES_PROTOCOLS = Collections
            .unmodifiableSet(new HashSet<>(Arrays.asList("action", "background", "codebase",
                    "href", "lowsrc", "src")));

    static Option<Element> findBody(Document htmlDocument) {
        Element html = htmlDocument.getRootElement();
        return findChildElement(html, "body");
    }

    static Option<Element> findChildElement(Element element, final String childElementName) {
        for (Object child : element.elements()) {
            if (!(child instanceof Element))
                continue;

            Element childElement = (Element) child;
            if (StringUtils.equalsIgnoreCase(childElementName, childElement.getName()))
                return Option.of(childElement);
        }

        return Option.empty();
    }

    static List<Element> findChildElements(Element element, final String childElementName) {
        Validate.notNull(element, "element");
        Validate.notNull(childElementName, "childElementName");

        List<Element> result = new ArrayList<>();
        for (Object child : element.elements()) {
            if (!(child instanceof Element))
                continue;

            Element childElement = (Element) child;

            if (StringUtils.equalsIgnoreCase(childElementName, childElement.getName())) {
                result.add(childElement);
            }
        }
        return result;
    }

    static Option<Element> findHead(Document htmlDocument) {
        Element html = htmlDocument.getRootElement();
        return findChildElement(html, "head");
    }

}
