package ru.yandex.chemodan.app.docviewer.utils.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.dom4j.Element;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.docviewer.utils.FileList;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;

public class HyperlinkProcessor extends AbstractDom4jVisitor {

    public static final Pattern LOCAL_FILE_PATTERN = Pattern.compile("(/?[\\w\\.-]+)+");

    private final SetF<String> createdFileNames;
    private boolean hasAnchors = false;

    public HyperlinkProcessor(Option<FileList> images) {
        this.createdFileNames = images.isPresent() ?
                images.get().getFiles().map(File2.nameM()).unique() :
                Cf.set();
    }

    @Override
    protected void visit(Element element) {
        if (StringUtils.equalsIgnoreCase("img", element.getName())) {
            String urlStr = element.attributeValue("src");

            if (StringUtils.isEmpty(urlStr)) {
                return;
            }

            Matcher matcher = LOCAL_FILE_PATTERN.matcher(urlStr);
            if (matcher.matches()) {
                element.addAttribute("src", null);
                if (createdFileNames.containsTs(urlStr)) {
                    HtmlPostprocessor.addLocalImageSrc(element, urlStr, false);
                } else {
                    HtmlPostprocessor.addImagePlaceHolder(element);
                }
                return;
            }

            element.addAttribute("src", "http://h.yandex.net/?" + UrlUtils.urlEncode(urlStr));
        }

        if (StringUtils.equalsIgnoreCase("a", element.getName())) {
            String urlStr = element.attributeValue("href");
            if (StringUtils.isEmpty(urlStr))
                return;

            if (urlStr.startsWith("#")) {
                hasAnchors = true;
            } else {
                element.addAttribute("href", "http://h.yandex.net/?" + UrlUtils.urlEncode(urlStr));
            }
        }

    }

    public boolean hasAnchors() {
        return hasAnchors;
    }
}
