package ru.yandex.chemodan.app.docviewer.utils.httpclient;

import java.security.cert.X509Certificate;

import org.apache.http.conn.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AlwaysTrustStrategy implements TrustStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AlwaysTrustStrategy.class);

    @Override
    public boolean isTrusted(X509Certificate[] chain, String authType) {
        logger.warn("SSL connection is used but without certificates chain check. "
                + "Auth type is '{}' and chain tail is '{}'", authType,
                chain[0].getSubjectX500Principal());
        return true;
    }
}
