package ru.yandex.chemodan.app.docviewer.utils.httpclient;

import org.apache.http.client.HttpClient;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.inside.passport.tvm2.AddServiceTicketInterceptor;
import ru.yandex.inside.passport.tvm2.AddUserTicketInterceptor;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.http.apache.v4.InstrumentedCloseableHttpClient;

/**
 * @author metal
 */
public class InternalHttpClient extends HttpClientWrapper {
    @Value("${internal.client.timeout}")
    private Duration timeout;
    @Value("${copier.threads}")
    private int threads;
    @Value("${internal.client.userAgent}")
    private String userAgent;

    private final AddServiceTicketInterceptor serviceTicketInterceptor;
    private final AddUserTicketInterceptor userTicketInterceptor;

    private boolean enableNativeUrlFetching = false;

    public InternalHttpClient(AddServiceTicketInterceptor serviceTicketInterceptor,
                              AddUserTicketInterceptor userTicketInterceptor)
    {
        this.serviceTicketInterceptor = serviceTicketInterceptor;
        this.userTicketInterceptor = userTicketInterceptor;
    }

    @Override
    protected HttpClient createHttpClient() {
        HttpClient httpClient = ApacheHttpClientUtils.Builder.create()
                .multiThreaded()
                .withHttpsSupport(ApacheHttpClientUtils.HttpsSupport.ENABLED)
                .withMaxConnections(threads)
                .withTimeout(Timeout.valueOf(timeout))
                .withUserAgent(userAgent)
                .withInterceptorLast(serviceTicketInterceptor)
                .withInterceptorLast(userTicketInterceptor)
                .disableRedirectHandling()
                .build();
        ((InstrumentedCloseableHttpClient) httpClient)
                .setHostnameProcessor(new DotReplacingHostnameProcessor());

        return httpClient;
    }

    public boolean isEnableNativeUrlFetching() {
        return enableNativeUrlFetching;
    }

    // for testing purpose
    public void setEnableNativeUrlFetching(boolean enableNativeUrlFetching) {
        this.enableNativeUrlFetching = enableNativeUrlFetching;
    }
}
