package ru.yandex.chemodan.app.docviewer.utils.httpclient;

import org.apache.http.client.HttpClient;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.inside.passport.tvm2.ByHostClientResolver;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.http.apache.v4.InstrumentedCloseableHttpClient;

/**
 * @author bursy
 */
public class MpfsHttpClient extends HttpClientWrapper {
    @Value("${mpfs.client.timeout}")
    private Duration timeout;
    @Value("${mpfs.client.threads}")
    private int threads;
    @Value("${mpfs.host}")
    private String mpfsHost;
    @Value("${tvm.mpfs.client-id}")
    private int clientId;

    private final Tvm2 tvm2;

    public MpfsHttpClient(Tvm2 tvm2) {
        this.tvm2 = tvm2;
    }

    @Override
    protected HttpClient createHttpClient() {
        ApacheHttpClientUtils.Builder builder = ApacheHttpClientUtils.Builder.create()
                .multiThreaded()
                .withTimeout(Timeout.valueOf(timeout))
                .withMaxConnections(threads)
                .withHttpsSupport()
                .disableRedirectHandling();

        if (EnvironmentType.getActive() != EnvironmentType.DEVELOPMENT
                && EnvironmentType.getActive() != EnvironmentType.TESTS)
        {
            builder = builder.withInterceptorLast(tvm2.serviceTicketInterceptor(
                    new ByHostClientResolver(Cf.map(mpfsHost, clientId))));
        }

        HttpClient httpClient = builder.build();
        ((InstrumentedCloseableHttpClient) httpClient)
                .setHostnameProcessor(new DotReplacingHostnameProcessor());
        return httpClient;
    }
}
