package ru.yandex.chemodan.app.docviewer.utils.httpclient;

import org.apache.http.client.HttpClient;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.chemodan.tvm2.SingleClientResolver;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.http.apache.v4.InstrumentedCloseableHttpClient;

/**
 * @author bursy
 */
public class MulcaHttpClient extends HttpClientWrapper {
    @Value("${mulca.gate.timeout}")
    private Duration timeout;
    @Value("${mulca.maxConnections}")
    private int maxConnections;

    @Value("${tvm.mulca.client-id}")
    private int mulcaClientId;
    @Value("${mulca.tvm2.enabled}")
    private boolean tvm2Enabled;

    @Value("${wmi.host}")
    private String wmiHost;
    @Value("${wmi.yt.host}")
    private String wmiYtHost;

    private Tvm2 tvm2;

    public MulcaHttpClient(Tvm2 tvm2) {
        this.tvm2 = tvm2;
    }

    @Override
    protected HttpClient createHttpClient() {
        ApacheHttpClientUtils.Builder builder = ApacheHttpClientUtils.Builder.create()
                .multiThreaded()
                .withTimeout(Timeout.valueOf(timeout))
                .withMaxConnections(maxConnections)
                .withUserAgent("Yandex DocViewer Mulca Client");

        if (tvm2Enabled) {
            builder = builder.withInterceptorLast(tvm2.serviceTicketInterceptor(new SingleClientResolver(mulcaClientId)));
        }

        HttpClient httpClient = builder.build();
        ((InstrumentedCloseableHttpClient) httpClient)
                .setHostnameProcessor(new DotReplacingHostnameProcessor());
        return httpClient;
    }
}
