package ru.yandex.chemodan.app.docviewer.utils.pdf;

import java.io.IOException;

import org.apache.pdfbox.cos.COSNumber;

import ru.yandex.misc.io.IoUtils;

/**
 * @author akirakozov
 */
public class PdfBoxInitializer {
    private final COSNumber holder;

    public PdfBoxInitializer() {
        // Hack to avoid deadlock in COSNumber, COSInteger initialization
        // https://st.yandex-team.ru/DOCVIEWER-2005
        // https://issues.apache.org/jira/browse/PDFBOX-845
        try {
            holder = COSNumber.get("0");
        } catch (IOException e) {
            throw IoUtils.translate(e);
        }
    }
}
