package ru.yandex.chemodan.app.docviewer.utils.pdf;

import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.annotation.MonicaStaticRegistry;
import ru.yandex.misc.monica.core.blocks.MeterMap;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

public class PdfWarmupMetrics {

    @MonicaMetric(description = "Total page requests count")
    @GroupByDefault
    public static final MeterMap totalPages = new MeterMap();

    @MonicaMetric(description = "Cached pages count")
    @GroupByDefault
    public static final MeterMap cachedPages = new MeterMap();

    @MonicaMetric(description = "Total block requests")
    @GroupByDefault
    public static final MeterMap totalBlocks = new MeterMap();

    @MonicaMetric(description = "Warm block count")
    @GroupByDefault
    public static final MeterMap warmBlocks = new MeterMap();

    static {
        MonicaStaticRegistry.register(
                PdfWarmupMetrics.class,
                new MetricGroupName(
                        "warmup",
                        new MetricName("pdf", "warmup"),
                        "Pdf warmup metrics"
                )
        );
    }

}
