package ru.yandex.chemodan.app.docviewer.utils.pdf.image;

import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.misc.enums.EnumResolver;

/**
 * @author akirakozov
 */
public enum PdfRenderTargetType {
    PNG(MimeTypes.MIME_IMAGE_PNG),
    JPG(MimeTypes.MIME_IMAGE_JPEG);

    private final String mimeType;

    PdfRenderTargetType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return mimeType;
    }

    public String value() {
        return name().toLowerCase();
    }

    public static final EnumResolver<PdfRenderTargetType> R = EnumResolver.er();
}
