package ru.yandex.chemodan.app.docviewer.utils.pdf.image;

import ru.yandex.chemodan.app.docviewer.adapters.poppler.ResizeOption;
import ru.yandex.chemodan.app.docviewer.storages.FileLink;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.OutputStreamSource;

public interface PdfRenderer {

    /**
     * @param pageIndex 1-based page index
     */
    RenderedImageInfo render(InputStreamSource pdfDocumentSource, int pageIndex,
            ResizeOption resize, OutputStreamSource imageFile);

    /**
     * @param pageIndex 1-based page index
     */
    RenderedImageInfo render(InputStreamSource pdfDocumentSource, int pageIndex,
            ResizeOption resize, PdfRenderTargetType targetType, OutputStreamSource imageFile);

    /**
     * @param pageIndex 1-based page index
     */
    RenderedImageInfo render(FileLink pdfLink, int pageIndex,
            ResizeOption resize, OutputStreamSource imageFile);

    /**
     * @param pageIndex 1-based page index
     */
    RenderedImageInfo render(FileLink pdfLink, int pageIndex, ResizeOption resize,
            PdfRenderTargetType targetType, OutputStreamSource imageFile);
}
