package ru.yandex.chemodan.app.docviewer.utils.pdf.image;

import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.docviewer.dao.pdfImage.ImageDaoUtils;
import ru.yandex.chemodan.app.docviewer.utils.DimensionO;
import ru.yandex.chemodan.util.bender.ISODateTimeUnmarshaller;

/**
 * @author akirakozov
 */
@Data
public class StoredImage {
    private static final ISODateTimeUnmarshaller dateTimeUnmarshaller = new ISODateTimeUnmarshaller();

    public final String fileId;
    public final String subId;

    public final Instant lastAccess;
    public final String fileLink;

    public final int pageIndex;
    public final DimensionO size;

    public StoredImage(String fileId, String subId, Instant lastAccess, String fileLink) {
        this.fileId = fileId;
        this.subId = subId;
        this.lastAccess = lastAccess;
        this.fileLink = fileLink;

        Tuple2<Integer, DimensionO> parsedSubId = ImageDaoUtils.parseSubId(String.valueOf(subId));
        this.pageIndex = parsedSubId.get1();
        this.size = parsedSubId.get2();
    }
}
