//package ru.yandex.chemodan.app.docviewer.utils.pdf.image;
//
//import java.util.zip.ZipEntry;
//
//import lombok.AllArgsConstructor;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//import ru.yandex.chemodan.app.docviewer.convert.TargetType;
//import ru.yandex.chemodan.app.docviewer.dao.pdfImage.ImageDao;
//import ru.yandex.chemodan.app.docviewer.dao.results.StoredResult;
//import ru.yandex.chemodan.app.docviewer.dao.results.StoredResultDao;
//import ru.yandex.chemodan.app.docviewer.storages.FileLink;
//import ru.yandex.chemodan.app.docviewer.storages.FileStorage;
//import ru.yandex.chemodan.app.docviewer.utils.DimensionO;
//import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
//import ru.yandex.chemodan.app.docviewer.utils.ZipEntryInputStreamSource;
//import ru.yandex.chemodan.app.docviewer.utils.cache.TemporaryFileCache;
//import ru.yandex.chemodan.app.docviewer.web.framework.ServletResponseOutputStreamSource;
//import ru.yandex.chemodan.app.docviewer.web.framework.exception.NotFoundException;
//import ru.yandex.misc.io.file.File2;
//
///**
// * @author vlsergey
// * @author swined
// */
//@AllArgsConstructor
//public class ZipImageHelper {
//
//    private static final Logger logger = LoggerFactory.getLogger(ZipImageHelper.class);
//    private static final String ROLE = ZipImageHelper.class.getName();
//
//    private final PdfImageCache pdfImageCache;
//    private final ImageDao pdfImageDao;
//    private final FileStorage resultHolder;
//    private final StoredResultDao storedResultDao;
//    private final TemporaryFileCache temporaryFileCache;
//
//
//    public void removeHtmlBackground(String fileId, int oneBasedPageIndex, DimensionO size) {
//        pdfImageCache.removeById(fileId, oneBasedPageIndex, size);
//    }
//
//    private StoredResult getStoredResult(String fileId, TargetType targetType) {
//        StoredResult storedResult = storedResultDao.find(fileId, targetType).getOrThrow(
//                () -> new NotFoundException("File specified were not converted"));
//        if (!storedResult.isConvertResultTypePdf()) {
//            throw new IllegalArgumentException("Specified file convert result is not PDF type");
//        }
//
//        final FileLink resultFileLink = resultHolder.toFileLink(storedResult.getFileLink().get());
//        final File2 resultFile = temporaryFileCache.getOrCreateTemporaryFile(resultFileLink,
//                resultHolder.getAsTempFileF());
//        FileUtils.withZipFile(resultFile, zipFile -> {
//            ZipEntry entry = zipFile.getEntry(request.name);
//            if (entry != null) {
//                resp.setContentType(mimeDetector.getMimeType(new ZipEntryInputStreamSource(zipFile, entry)));
//                new ServletResponseOutputStreamSource(resp).writeFrom(new ZipEntryInputStreamSource(zipFile, entry));
//            } else {
//                getImagePlaceHolder(resp);
//            }
//            return null;
//        });
//        temporaryFileCache.removeFromCache(resultFileLink);
//
//        return storedResult;
//    }
//
//}
