package ru.yandex.chemodan.app.docviewer.utils.pdf.text;

import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.XmlAttribute;
import ru.yandex.misc.bender.annotation.XmlText;

/**
 * @author akirakozov
 */
@Bendable
@Data
@NoArgsConstructor
public class Document {

    @BenderPart(name = "page")
    private List<Page> pages;

    public Document(List<Page> pages) {
        this.pages = Collections.unmodifiableList(pages);
    }

    public Page getPage(int num) {
        return pages.get(num);
    }

    @Bendable
    @Data
    @EqualsAndHashCode(callSuper = true)
    @NoArgsConstructor
    public static class Page extends TextRegion {
        @XmlAttribute
        private int index;
        @BenderPart(name = "line")
        private List<LinePosition> lines;

        public Page(int index, int left, int top, int width, int height, List<LinePosition> lines) {
            super(left, top, width, height);
            this.index = index;
            this.lines = Cf.toList(lines);
        }

        public List<WordPosition> getAllWordPositions() {
            ListF<WordPosition> words = Cf.arrayList();
            for (LinePosition line : lines) {
                words.addAll(line.words);
            }
            return words;
        }

        public LinePosition getLine(int num) {
            return lines.get(num);
        }
    }

    @Bendable
    @Data
    @NoArgsConstructor
    @EqualsAndHashCode(callSuper = true)
    public static class LinePosition extends TextRegion {

        @BenderPart(name = "word")
        private List<WordPosition> words;

        public LinePosition(ListF<WordPosition> words, int left, int top, int width, int height) {
            super(left, top, width, height);
            this.words = Cf.toList(words);
        }

        public WordPosition getWord(int num) {
            return words.get(num);
        }
    }

    @Bendable
    @Data
    @EqualsAndHashCode(callSuper = true)
    @NoArgsConstructor
    public static class WordPosition extends TextRegion {
        @XmlText
        private String word;

        WordPosition(String word, int left, int top, int width, int height) {
            super(left, top, width, height);
            this.word = word;
        }
    }

    @Bendable
    @Data
    @NoArgsConstructor
    @JsonFormat(shape=JsonFormat.Shape.ARRAY)
    public static class TextRegion {
        @XmlAttribute(name="h")
        private int height;
        @XmlAttribute(name="l")
        private int left;
        @XmlAttribute(name="t")
        private int top;
        @XmlAttribute(name="w")
        private int width;

        public TextRegion(int left, int top, int width, int height) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
        }
    }

}
