package ru.yandex.chemodan.app.docviewer.utils.pdf.text;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.serialize.BenderXmlSerializer;

/**
 * @author akirakozov
 */
public class WordPositionSerializer {

    private static final BenderXmlSerializer<Document> serializer = Bender.xmlSerializer(Document.class);

    private static final ObjectMapper mapper = new ObjectMapper();

    public static byte[] serializeToBytes(Document document) {
        return serializer.serializeXml(document);
    }

    static Document deserializeJson(InputStream inputStream) throws IOException {
        return mapper.readValue(inputStream, Document.class);
    }

    public static Document deserializeJsonCompressed(byte[] bs) {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(bs));
            zipInputStream.getNextEntry();
            return deserializeJson(zipInputStream);
        } catch (Exception exc) {
            throw ExceptionUtils.translate(exc);
        }
    }

    public static byte[] serializeJsonCompressed(Document wordPositions) {
        return serializeJsonCompressed(wordPositions, Deflater.BEST_SPEED);
    }

    public static byte[] serializeJsonCompressed(Document wordPositions, int compressionLevel) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            zipOutputStream.setLevel(compressionLevel);
            zipOutputStream.putNextEntry(new ZipEntry("content.json"));

            mapper.writeValue(zipOutputStream, wordPositions);
            zipOutputStream.close();
            byteArrayOutputStream.close();

            return byteArrayOutputStream.toByteArray();
        } catch (Exception exc) {
            throw ExceptionUtils.translate(exc);
        }
    }

}
