package ru.yandex.chemodan.app.docviewer.utils.scheduler;

import java.util.concurrent.Callable;

public interface Scheduler {

    int getMaxLocalThreads();

    boolean isEmpty();

    boolean isScheduled(String taskKey);

    <T> PrioritizedFutureTask<String, T> scheduleGlobalTask(String taskKey, Callable<T> task, float newPriority);

    <T> PrioritizedFutureTask<String, T> scheduleLocalTask(String taskKey, Callable<T> task, float newPriority);

    int getActiveWorkers();

    long getQueueLength();
}
