package ru.yandex.chemodan.app.docviewer.utils.security;

import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;

import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.chemodan.app.docviewer.states.ErrorCode;
import ru.yandex.chemodan.app.docviewer.states.UserException;
import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.InputStreamXUtils;
import ru.yandex.misc.io.IoUtils;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @author akirakozov
 */
public class ContentSecurityChecker {
    private static final String COM_MICROSOFT_WEBSERVICE_METHOD = "com.microsoft.webservice";

    public static final ContentSecurityChecker CHECKER = new ContentSecurityChecker();

    public void checkContent(String contentType, InputStreamSource content) {
        // DOCVIEWER-2665: Temporary security hotfix
        if (MimeTypes.MIME_OPENDOCUMENT_SPREADSHEET.equals(contentType)) {
            FileUtils.withZipFile(content, this::checkWebserviceUsageInODS);
        }
    }

    private void checkWebserviceUsageInODS(ZipFile zipFile) {
        ZipEntry zipEntry = zipFile.getEntry("content.xml");
        try {
            // TODO: don't read all content in memory
            Document content = Dom4jUtils.read(InputStreamXUtils.wrap(zipFile.getInputStream(zipEntry)).readBytes());
            List formulasAttr = content.selectNodes("//table:table-cell/@table:formula");
            for (Object attr : formulasAttr) {
                if (attr instanceof Attribute && isNonSecureFormula(((Attribute) attr).getValue())) {
                    throw new UserException(ErrorCode.UNSUPPORTED_CONVERTION, "File contains non-secure method calls");
                }
            }
        } catch (IOException e) {
            throw IoUtils.translate(e);
        }
    }

    boolean isNonSecureFormula(String value) {
        String normalized = StringEscapeUtils.unescapeHtml4(value).toLowerCase();
        return normalized.contains(COM_MICROSOFT_WEBSERVICE_METHOD);
    }
}
