package ru.yandex.chemodan.app.docviewer.web;

import java.util.Properties;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.docviewer.config.ConvertersContextConfiguration;
import ru.yandex.chemodan.app.docviewer.config.CoreContextConfiguration;
import ru.yandex.chemodan.app.docviewer.config.DocumentsCleanupContextConfiguration;
import ru.yandex.chemodan.app.docviewer.config.DocumentsCleanupSettingsConfiguration;
import ru.yandex.chemodan.app.docviewer.config.DocviewerActiveProfiles;
import ru.yandex.chemodan.app.docviewer.config.DocviewerBazingaWorkerContextConfiguration;
import ru.yandex.chemodan.app.docviewer.config.ImagesCleanupContextConfiguration;
import ru.yandex.chemodan.app.docviewer.config.admin.DvMongoAdminContextConfiguration;
import ru.yandex.chemodan.app.docviewer.config.web.WebContextConfiguration;
import ru.yandex.chemodan.app.docviewer.graphite.GraphiteContextConfiguration;
import ru.yandex.chemodan.app.docviewer.log.DocviewerLogHelper;
import ru.yandex.chemodan.app.docviewer.monica.MonicaDvContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.StdOutErrLogger;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.log.LogRotation;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.property.PropertiesUtils;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

public class DocviewerMain extends ChemodanMainSupport {
    private static final Logger logger = LoggerFactory.getLogger(DocviewerMain.class);

    private static final String CORP_ENV_TYPE = "corp";

    public static void main(String[] args) {
        new DocviewerMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("docviewer", "web");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(ChemodanCommonContextConfiguration.class,
                CoreContextConfiguration.class,
                WebContextConfiguration.class,
                ConvertersContextConfiguration.class,
                MonicaDvContextConfiguration.class,
                GraphiteContextConfiguration.class,
                DvMongoAdminContextConfiguration.class,
                DocumentsCleanupSettingsConfiguration.class,
                DocviewerBazingaWorkerContextConfiguration.class,
                DocumentsCleanupContextConfiguration.class,
                ImagesCleanupContextConfiguration.class);
    }

    @Override
    protected void configureLogger() {
        AppName appName = applicationName();
        DocviewerLogHelper.configureRootFileLogger(appName);
        DocviewerLogHelper.configureAccessLogger(appName);
        DocviewerLogHelper.configureEventsLogger(appName);
    }

    @Override
    public void initializeLogger() {
        if (isRedirectSystemOutToLog()) {
            if (isInitializeLogger()) {
                configureLogger();
            }
            if (isDaemon()) {
                StdOutErrLogger.redirectSystemOutErrToLog();
                LogRotation.installSignalHandler();
            }
        } else {
            super.initializeLogger();
        }
    }

    protected boolean isRedirectSystemOutToLog() {
        return true;
    }

    @Override
    public Tuple2<Properties, String[]> loadProperties(String[] pArgs) {
        Tuple2<Properties, String[]> r = super.loadProperties(args);
        if (isDaemon()) {
            PropertiesUtils.dump(r._1, logger);
        }
        return r;
    }

    @Override
    protected String log4jXmlPath() {
        return "";
    }

    @Override
    public ListF<String> additionalSpringProfiles() {
        return EnvironmentType.getActiveSecondary().filter(envType -> CORP_ENV_TYPE.equals(envType)).isPresent() ?
                Cf.list() :
                Cf.list(DocviewerActiveProfiles.EXTERNAL_DOWNLOADER);
    }
}
