package ru.yandex.chemodan.app.docviewer.web.backend;

import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.dao.results.StoredResult;
import ru.yandex.chemodan.app.docviewer.utils.XmlUtils2;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractXmlActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.WebSecurityManager;

@SuppressWarnings("serial")
public abstract class AbstractPageInfoAction extends AbstractXmlActionServlet<PageRequest> implements BackendServlet {

    @Autowired
    private StoredResultHelper storedResultHelper;

    @Autowired
    private WebSecurityManager webSecurityManager;


    protected abstract void execute(PageRequest request, StoredResult storedResult, Element pageElement);

    @Override
    public void execute(PageRequest request, Document doc) {
        webSecurityManager.validateFileRightUsingUid(request.uid, request.id);

        StoredResult storedResult = storedResultHelper.getValidatedResult(request.id, getConvertTargetMobileIncluded(request));
        storedResultHelper.validatePage(storedResult, request.page);

        int totalPages = storedResult.getPages().getOrElse(Integer.MAX_VALUE);

        Element pageElement = doc.addElement("page");
        pageElement.addAttribute("current-page", String.valueOf(request.page));
        pageElement.addAttribute("total-pages", String.valueOf(totalPages));

        XmlUtils2.appendProperties(pageElement, storedResult.getDocumentProperties());

        execute(request, storedResult, pageElement);

        storedResultHelper.updateResultLastAccess(storedResult);
    }

    protected abstract TargetType getConvertTargetType();

    @Override
    protected TargetType getConvertTargetMobileIncluded(DocviewerRequest request) {
        TargetType currentTargetType = getConvertTargetType();
        return currentTargetType == TargetType.HTML_WITH_IMAGES && request.mobile
                ? TargetType.HTML_WITH_IMAGES_FOR_MOBILE
                : currentTargetType;
    }

}
