package ru.yandex.chemodan.app.docviewer.web.backend;

import org.jetbrains.annotations.Nullable;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.ActionParameter;
import ru.yandex.inside.passport.PassportUidOrZero;

public abstract class AbstractSourceRequest extends DocviewerRequest {
    @ActionParameter
    PassportUidOrZero uid;

    @ActionParameter
    @Nullable
    String name;

    @ActionParameter
    boolean inline = false;

    abstract Option<String> getSession();

    abstract Option<String> getArchivePath();

    abstract Option<String> getUrl();

    abstract Option<String> getFileId();
}
