package ru.yandex.chemodan.app.docviewer.web.backend;

import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.states.StateMachine;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractXmlActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.WebSecurityManager;

@SuppressWarnings("serial")
public class FileInfoAction extends AbstractXmlActionServlet<FileInfoRequest> implements BackendServlet {

    @Autowired
    private StateMachine stateMachine;

    @Autowired
    private WebSecurityManager webSecurityManager;

    @Override
    public String getActionUrl() {
        return "/fileinfo";
    }

    @Override
    public void execute(FileInfoRequest request, Document doc) {
        webSecurityManager.validateFileRightUsingUid(request.uid, request.id);

        doc.add(stateMachine.getInfo(request.uid, request.id, request.session));
    }
}
