package ru.yandex.chemodan.app.docviewer.web.backend;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequestWithUid;
import ru.yandex.chemodan.app.docviewer.web.framework.ActionParameter;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;

public class FileRequest extends DocviewerRequestWithUid {

    @ActionParameter
    public String id;

    public Function0<String> toUriF(final HttpServletRequest servletRequest) {
        return () -> {
            Tuple2List<String, String> parameters = Tuple2List.arrayList();
            if (StringUtils.isNotEmpty(id)) {
                parameters.add("id", id);
            }
            if (uid != null) {
                parameters.add("uid", String.valueOf(uid.getUid()));
            }
            final String queryParameters = UrlUtils.listMapToUrlParameters(parameters);
            return servletRequest.getRequestURI() + "?" + queryParameters;
        };
    }
}
