package ru.yandex.chemodan.app.docviewer.web.backend;

import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.dao.properties.Properties;
import ru.yandex.chemodan.app.docviewer.dao.properties.PropertiesDao;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequest;
import ru.yandex.chemodan.app.docviewer.web.backend.GetPropertiesAction.GetPropertiesRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractXmlActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.ActionParameter;
import ru.yandex.chemodan.app.docviewer.web.framework.exception.BadRequestException;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author akirakozov
 */
public class GetPropertiesAction extends AbstractXmlActionServlet<GetPropertiesRequest> implements BackendServlet {

    public static class GetPropertiesRequest extends DocviewerRequest {
        @ActionParameter(required = true)
        PassportUidOrZero uid;
    }

    @Autowired
    private PropertiesDao propertiesDao;

    @Override
    public void execute(GetPropertiesRequest request, Document doc) {
        if (!request.uid.isAuthenticated()) {
            throw new BadRequestException("Unauthorized request");
        }

        Element root = doc.addElement("properties");
        Option<Properties> props = propertiesDao.findProperties(request.uid.toPassportUid());
        if (props.isPresent()) {
            MapF<String, String> properties = props.get().getProperties();
            for (String key : properties.keys()) {
                Element property = root.addElement("property");
                property.addAttribute("key", key);
                property.addAttribute("value", properties.getTs(key));
            }
        }
    }

    @Override
    public String getActionUrl() {
        return "/get-properties";
    }
}
