package ru.yandex.chemodan.app.docviewer.web.backend;

import java.util.NoSuchElementException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import lombok.RequiredArgsConstructor;
import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.copy.StoredUriManager;
import ru.yandex.chemodan.app.docviewer.copy.UriHelper;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequestWithUid;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractXmlActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.ActionParameter;
import ru.yandex.chemodan.app.docviewer.web.framework.WebSecurityManager;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mpfs.MpfsPublicSettings;
import ru.yandex.chemodan.mpfs.MpfsUser;
import ru.yandex.chemodan.util.exception.PermanentHttpFailureException;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author friendlyevil
 */
@RequiredArgsConstructor
public class GetPublicSettingsAction extends AbstractXmlActionServlet<GetPublicSettingsAction.GetPublicSettingsRequest> implements BackendServlet {
    @Autowired
    private WebSecurityManager webSecurityManager;
    @Autowired
    private StoredUriManager storedUriManager;
    @Autowired
    private MpfsClient mpfsClient;
    @Autowired
    private UriHelper uriHelper;

    @Override
    public String getActionUrl() {
        return "/public-settings";
    }

    @Override
    protected void doGetImpl(HttpServletRequest req, GetPublicSettingsRequest request, HttpServletResponse resp) {
        try {
            String hash = extractPrivateHashFromUri(request.url);
            MpfsUser user = MpfsUser.of(request.uid);
            MpfsPublicSettings publicSettings = mpfsClient.getPublicSettingsByHash(user, hash);

            resp.setContentType("application/json");
            resp.getOutputStream().write(publicSettings.serialize());
        } catch (NoSuchElementException e) {
            throw new HttpException(HttpStatus.SC_404_NOT_FOUND, e.getMessage(), e);
        } catch (PermanentHttpFailureException e) {
            throw new HttpException(e.getStatusCode().orElse(HttpStatus.SC_500_INTERNAL_SERVER_ERROR), e.getMessage(), e);
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
    }

    private String extractPrivateHashFromUri(String url) {
        ActualUri uri = uriHelper.rewrite(DocumentSourceInfo.builder().originalUrl(url).build());

        // доджен отработать DiskPublicUrlProvider, иначе будет NoSuchElementException на getPrivateHash
        Option<DiskResourceId> resourceId = uriHelper.getDiskResourceId(uri);
        return resourceId.get().getPrivateHash();
    }

    @Override
    public void execute(GetPublicSettingsRequest request, Document doc) {  }

    public static class GetPublicSettingsRequest extends DocviewerRequestWithUid {
        @ActionParameter(required = true)
        String url;
    }
}
