package ru.yandex.chemodan.app.docviewer.web.backend;

import javax.servlet.http.HttpServletRequest;

import lombok.Data;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.ActionParameter;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;

@Data
public class HtmlImageRequest extends DocviewerRequest {

    @ActionParameter
    int height = Integer.MAX_VALUE;

    @ActionParameter
    String id;

    @ActionParameter
    String name;

    @ActionParameter
    int width = Integer.MAX_VALUE;

    @ActionParameter
    PassportUidOrZero uid;

    @ActionParameter
    boolean placeholder;

    public Function0<String> toUriF(final HttpServletRequest servletRequest) {
        return () -> {
            Tuple2List<String, String> parameters = Tuple2List.arrayList();
            if (StringUtils.isNotEmpty(id)) {
                parameters.add("id", id);
            }
            if (StringUtils.isNotEmpty(name)) {
                parameters.add("name", name);
            }
            if (height != Integer.MAX_VALUE) {
                parameters.add("height", String.valueOf(height));
            }
            if (width != Integer.MAX_VALUE) {
                parameters.add("width", String.valueOf(width));
            }
            if (uid != null) {
                parameters.add("uid", String.valueOf(uid.getUid()));
            }
            final String queryParameters = UrlUtils.listMapToUrlParameters(parameters);
            return servletRequest.getRequestURI() + "?" + queryParameters;
        };
    }
}
