package ru.yandex.chemodan.app.docviewer.web.backend;

import org.dom4j.Document;
import org.dom4j.Element;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.disk.DiskManager;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsOperationStatus;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsOperationStatusWithMeta;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequest;
import ru.yandex.chemodan.app.docviewer.web.backend.MpfsOperationStatusAction.MpfsOperationStatusActionRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractXmlActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.ActionParameter;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author metal
 */
public class MpfsOperationStatusAction extends AbstractXmlActionServlet<MpfsOperationStatusActionRequest>
        implements BackendServlet
{

    public static class MpfsOperationStatusActionRequest extends DocviewerRequest {
        @ActionParameter
        PassportUidOrZero uid;

        @ActionParameter
        String oid;

        @ActionParameter
        @Nullable
        String meta;
    }

    @Autowired
    private DiskManager diskManager;

    @Override
    public void execute(MpfsOperationStatusActionRequest request, Document doc) {
        MpfsOperationStatusWithMeta status = diskManager.getMpfsOperationStatusWithMeta(
                request.uid, request.oid, Option.ofNullable(request.meta));

        Element root = doc.addElement("operation");
        root.addAttribute("status", status.status.name());
        if (status.status == MpfsOperationStatus.DONE && status.meta.isPresent()) {
            root.addElement("meta").addText(status.meta.get());
        }
    }

    @Override
    public String getActionUrl() {
        return "/mpfs-operation-status";
    }
}
