package ru.yandex.chemodan.app.docviewer.web.backend;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.mutable.MutableLong;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import ru.yandex.chemodan.app.docviewer.adapters.poppler.ResizeOption;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.dao.results.StoredResult;
import ru.yandex.chemodan.app.docviewer.storages.FileLink;
import ru.yandex.chemodan.app.docviewer.storages.FileStorage;
import ru.yandex.chemodan.app.docviewer.utils.DimensionO;
import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.PdfRenderer;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.RenderedImageInfo;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.ServletResponseOutputStreamSource;
import ru.yandex.chemodan.app.docviewer.web.framework.WebSecurityManager;
import ru.yandex.chemodan.app.docviewer.web.framework.exception.BadRequestException;
import ru.yandex.misc.io.IoFunction1V;
import ru.yandex.misc.io.OutputStreamSource;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.io.file.FileOutputStreamSource;
import ru.yandex.misc.lang.StringUtils;

@SuppressWarnings("serial")
public class PdfPageImageAction extends AbstractActionServlet<PageRequest> implements BackendServlet {

    public static final String PATH = "/pdfpageimage";

    @Autowired
    private PdfRenderer pdfRenderer;

    @Autowired
    @Qualifier("resultHolder")
    private FileStorage resultHolder;

    @Autowired
    private StoredResultHelper storedResultHelper;

    @Autowired
    private WebSecurityManager webSecurityManager;

    @Override
    public String getActionUrl() {
        return "/pdfpageimage";
    }

    @Override
    protected void doGetImpl(final HttpServletRequest req, final PageRequest request,
            final HttpServletResponse resp)
    {
        final MutableLong imageFileSize = new MutableLong(-1);

        if (StringUtils.isEmpty(request.id))
            throw new BadRequestException("File ID is not specified");
        if (request.uid == null)
            throw new BadRequestException("User ID is not specified");
        if (request.page <= 0)
            throw new BadRequestException("Page is not specified");

        webSecurityManager.validateFileRightUsingUid(request.uid, request.id);

        final StoredResult storedResult = storedResultHelper.getValidatedResult(request.id, TargetType.PDF);
        final FileLink pdfFileLink = resultHolder.toFileLink(storedResult.getFileLink().get());

        FileUtils.withEmptyTemporaryFile("fileaction", ".png", (IoFunction1V<File2>) temp -> {
            RenderedImageInfo imageInfo = pdfRenderer.render(
                    pdfFileLink,
                    request.page,
                    ResizeOption.scale(DimensionO.cons(request.width, request.height)),
                    new FileOutputStreamSource(temp));

            imageFileSize.setValue(temp.length());

            resp.setContentType(imageInfo.contentType);

            OutputStreamSource outputStreamSource = new ServletResponseOutputStreamSource(resp);
            outputStreamSource.writeFrom(temp);
        });
    }
}
