package ru.yandex.chemodan.app.docviewer.web.backend;

import org.dom4j.Element;

import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.convert.result.PageInfo;
import ru.yandex.chemodan.app.docviewer.convert.result.PagesInfo;
import ru.yandex.chemodan.app.docviewer.dao.results.StoredResult;

@SuppressWarnings("serial")
public class PdfPageInfoAction extends AbstractPageInfoAction {

    public PdfPageInfoAction() {
        super();
    }

    @Override
    public String getActionUrl() {
        return "/pdfpageinfo";
    }

    @Override
    protected void execute(PageRequest request, StoredResult storedResult, Element pageElement) {
        final String requestFileId = request.id;
        final int requestPage = request.page;
        final int requestPageWidth = request.width;

        pageElement.addElement("url").addText(
                PdfPageImageAction.PATH + "?id=" + requestFileId + "&page=" + requestPage
                        + "&width=" + requestPageWidth);

        final int pageWidth = requestPageWidth;
        pageElement.addElement("width").addText(String.valueOf(pageWidth));

        if (storedResult.getPagesInfo().isPresent()) {
            PagesInfo pagesInfo = storedResult.getPagesInfo().get();
            for (PageInfo pageInfo : pagesInfo.getPageInfos()) {
                if (pageInfo.getIndex().isSome(requestPage)) {
                    if (pageInfo.getWidth().isPresent() && pageInfo.getHeight().isPresent()) {
                        float originalWidth = pageInfo.getWidth().get();
                        float originalHeight = pageInfo.getHeight().get();
                        if (originalWidth != 0) {
                            final int pageHeight = Math.round(pageWidth * originalHeight
                                    / originalWidth);
                            pageElement.addElement("height").addText(String.valueOf(pageHeight));
                        }
                    }
                    break;
                }
            }
        }
    }

    @Override
    protected TargetType getConvertTargetType() {
        return TargetType.PDF;
    }
}
