package ru.yandex.chemodan.app.docviewer.web.backend;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.utils.DimensionO;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.PdfHelper;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractActionServlet;

public class PrerenderHtmlImageAction extends AbstractActionServlet<PrerenderHtmlImageRequest> implements BackendServlet {

    public static final String URL = "/prerender-html-image";

    private final PdfHelper pdfHelper;

    public PrerenderHtmlImageAction(PdfHelper pdfHelper) {
        this.pdfHelper = pdfHelper;
    }

    @Override
    public String getActionUrl() {
        return URL;
    }

    @Override
    protected void doGetImpl(HttpServletRequest req, PrerenderHtmlImageRequest request, HttpServletResponse resp) {
        TargetType targetType = request.mobile ? TargetType.HTML_WITH_IMAGES_FOR_MOBILE : TargetType.HTML_WITH_IMAGES;
        pdfHelper.schedulePrerenderPdfImagesArroundCurrentPage(request.fileId, request.oneBasedPageIndex,
                DimensionO.cons(request.width, request.height), targetType);
    }
}
