package ru.yandex.chemodan.app.docviewer.web.backend;

import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.disk.AsyncCopyStatus;
import ru.yandex.chemodan.app.docviewer.disk.DiskManager;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsOperationStatus;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractXmlActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.ActionParameter;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.lang.Validate;

/**
 * @author akirakozov
 */
public class PublishStatusAction extends AbstractXmlActionServlet<PublishStatusAction.PublishStatusRequest>
        implements BackendServlet
{

    public static class PublishStatusRequest extends DocviewerRequest {
        @ActionParameter
        PassportUidOrZero uid;

        @ActionParameter
        String oid;
    }

    @Autowired
    private DiskManager diskManager;

    @Override
    public void execute(PublishStatusRequest request, Document doc) {
        AsyncCopyStatus status = diskManager.getAsyncCopyStatus(request.uid, request.oid);

        Element root = doc.addElement("operation");
        root.addAttribute("status", status.status.name());
        if (status.status == MpfsOperationStatus.DONE) {
            Validate.some(status.shortUrl, "Operations is done, but short_url is not found");
            root.addElement("short-url").addText(status.shortUrl.get());
        }
    }

    @Override
    public String getActionUrl() {
        return "/publish-status";
    }
}
