package ru.yandex.chemodan.app.docviewer.web.backend;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.chemodan.app.docviewer.utils.cache.TemporaryFilesCleaner;
import ru.yandex.chemodan.app.docviewer.utils.scheduler.Scheduler;
import ru.yandex.chemodan.app.docviewer.web.framework.exception.ServiceUnavailableException;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class RateLimiter {

    private static final Logger logger = LoggerFactory.getLogger(RateLimiter.class);

    @Autowired
    private Scheduler copierScheduler;
    @Autowired
    private TemporaryFilesCleaner temporaryFilesCleaner;
    @Value("${docviewer.copier.queue.limit}")
    private Integer queueLimit = 8;

    public boolean checkRejectRequest() {
        return temporaryFilesCleaner.checkCritLowSpace() ||
                copierScheduler.getQueueLength() > queueLimit;
    }

    public void logReject() {
        logger.warn("Rejected request, Queue size: {} / {}, space: {}",
                copierScheduler.getQueueLength(), queueLimit, FileUtils.getTempFreeSize());
    }

    public void rejectRequest() {
        if (checkRejectRequest()) {
            logReject();
            throw new ServiceUnavailableException();
        }
    }

    public boolean rejectRequest(HttpServletResponse resp) {
        if (checkRejectRequest()) {
            resp.setStatus(HttpStatus.SC_503_SERVICE_UNAVAILABLE);
            logReject();
            return true;
        }
        return false;
    }
}
