package ru.yandex.chemodan.app.docviewer.web.backend;

import lombok.Data;
import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.storages.FileLink;
import ru.yandex.chemodan.app.docviewer.utils.DimensionO;
import ru.yandex.chemodan.app.docviewer.utils.cache.TemporaryFileCache;
import ru.yandex.chemodan.app.docviewer.utils.html.HtmlSplitter;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.PdfHelper;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractXmlActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.ActionParameter;
import ru.yandex.chemodan.app.docviewer.web.framework.exception.BadRequestException;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@SuppressWarnings("serial")
public class RenderImageAction extends AbstractXmlActionServlet<RenderImageAction.RenderImageRequest>
        implements BackendServlet
{

    private static final Logger logger = LoggerFactory.getLogger(RenderImageAction.class);

    public static final String URL = "/render-html-image";

    @Autowired
    private PdfHelper pdfHelper;

    @Autowired
    private TemporaryFileCache temporaryFileCache;

    @Autowired
    private HtmlSplitter htmlSplitter;

    @Autowired
    private RateLimiter rateLimiter;

    @Override
    public String getActionUrl() {
        return URL;
    }

    @Override
    public void execute(RenderImageRequest request, Document doc) {
        rateLimiter.rejectRequest();

        TargetType targetType = request.mobile ? TargetType.HTML_WITH_IMAGES_FOR_MOBILE : TargetType.HTML_WITH_IMAGES;

        if (request.getIndex() > -1) {
            FileLink link = pdfHelper.getHtmlBackgroundImageLinkInplace(
                    request.id, request.getIndex(),
                    DimensionO.cons(request.width, request.height),
                    targetType);
            logger.info("Resolved link {} for request {}", link, request);
            doc.addElement("link").addText(link.toString());
        } else {
            throw new BadRequestException("Invalid page index: " + request);
        }
    }

    @Data
    public static class RenderImageRequest extends DocviewerRequest {

        @ActionParameter
        int height = Integer.MAX_VALUE;

        @ActionParameter
        int width = Integer.MAX_VALUE;

        @ActionParameter
        String id;

        @ActionParameter
        Integer index;

    }

}
