package ru.yandex.chemodan.app.docviewer.web.backend;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.dao.results.StoredResult;
import ru.yandex.chemodan.app.docviewer.storages.FileLink;
import ru.yandex.chemodan.app.docviewer.storages.FileStorage;
import ru.yandex.chemodan.app.docviewer.utils.cache.TemporaryFileCache;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.ServletResponseOutputStreamSource;
import ru.yandex.chemodan.app.docviewer.web.framework.WebSecurityManager;
import ru.yandex.chemodan.app.docviewer.web.framework.exception.BadRequestException;
import ru.yandex.misc.io.OutputStreamSource;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.StringUtils;

@SuppressWarnings("serial")
public abstract class ResultAction extends AbstractActionServlet<ResultRequest> implements BackendServlet {

    private final String charset;

    private final String contentType;

    private final TargetType targetType;

    @Autowired
    @Qualifier("resultHolder")
    private FileStorage resultHolder;

    @Autowired
    private StoredResultHelper storedResultHelper;

    @Autowired
    private TemporaryFileCache temporaryFileCache;

    @Autowired
    private WebSecurityManager webSecurityManager;

    public ResultAction(TargetType targetType, String contentType, String charset) {
        this.targetType = targetType;
        this.contentType = contentType;
        this.charset = charset;
    }

    @Override
    protected void doGetImpl(HttpServletRequest req, ResultRequest request, HttpServletResponse resp) {
        if (request.uid == null) {
            throw new BadRequestException("User ID ('uid') not specified");
        }
        if (StringUtils.isEmpty(request.id)) {
            throw new BadRequestException("No file id specified in request");
        }

        webSecurityManager.validateFileRightUsingUid(request.uid, request.id);

        StoredResult storedResult = storedResultHelper.getValidatedResult(request.id,
                request.mobile ? TargetType.HTML_WITH_IMAGES_FOR_MOBILE : targetType);

        final FileLink resultFileLink = resultHolder.toFileLink(storedResult.getFileLink().get());
        final File2 temporary = temporaryFileCache.getOrCreateTemporaryFile(resultFileLink,
                resultHolder::getAsTempFile);

        resp.setContentType(contentType);

        if (StringUtils.isNotEmpty(charset))
            resp.setCharacterEncoding(charset);

        OutputStreamSource outputStreamSource = new ServletResponseOutputStreamSource(resp);
        outputStreamSource.writeFrom(temporary);
    }
}
