package ru.yandex.chemodan.app.docviewer.web.backend;

import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.dao.properties.PropertiesDao;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequest;
import ru.yandex.chemodan.app.docviewer.web.backend.SavePropertyAction.SavePropertyRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractXmlActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.ActionParameter;
import ru.yandex.chemodan.app.docviewer.web.framework.exception.BadRequestException;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author akirakozov
 */
public class SavePropertyAction extends AbstractXmlActionServlet<SavePropertyRequest> implements BackendServlet {

    public static class SavePropertyRequest extends DocviewerRequest {
        @ActionParameter(required = true)
        PassportUidOrZero uid;

        @ActionParameter(required = true)
        String key;

        @ActionParameter(required = true)
        String value;
    }

    @Autowired
    private PropertiesDao propertiesDao;

    @Override
    public String getActionUrl() {
        return "/save-property";
    }

    @Override
    public void execute(SavePropertyRequest request, Document doc) {
        if (!request.uid.isAuthenticated()) {
            throw new BadRequestException("Unauthorized request");
        }

        propertiesDao.setProperty(request.uid.toPassportUid(), request.key, request.value);
        doc.addElement("ok");
    }
}
