package ru.yandex.chemodan.app.docviewer.web.backend;

import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.copy.UriHelper;
import ru.yandex.chemodan.app.docviewer.dao.sessions.SessionDao;
import ru.yandex.chemodan.app.docviewer.dao.sessions.SessionKey;
import ru.yandex.chemodan.app.docviewer.dao.sessions.SessionKey.SessionConvertPassword;
import ru.yandex.chemodan.app.docviewer.dao.sessions.SessionKey.SessionCopyPassword;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractXmlActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.exception.BadRequestException;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author ssytnik
 */
@SuppressWarnings("serial")
public class SessionWriteAction extends AbstractXmlActionServlet<SessionWriteRequest> implements BackendServlet {

    public static final String COPY_PASSWORD = SessionCopyPassword.PREFIX;
    private static final String CONVERT_PASSWORD = SessionConvertPassword.PREFIX;

    @Autowired
    private UriHelper uriHelper;

    @Autowired
    private SessionDao sessionDao;

    @Override
    public String getActionUrl() {
        return "/session-write";
    }

    @Override
    public void execute(SessionWriteRequest request, Document doc) {
        SessionKey key;

        switch (request.keyType) {
            case COPY_PASSWORD:
                if (request.uid == null) {
                    throw new BadRequestException("No UID is specified");
                }
                if (StringUtils.isEmpty(request.url)) {
                    throw new BadRequestException("No URL is specified");
                }

                DocumentSourceInfo source = DocumentSourceInfo.builder().originalUrl(request.url).uid(request.uid)
                        .archivePath(StringUtils.notEmptyO(request.archivePath)).build()
                        .withShowNda(request.showNda);

                final ActualUri actualUri = uriHelper.rewrite(source);
                key = new SessionCopyPassword(actualUri);

                break;
            case CONVERT_PASSWORD:
                if (StringUtils.isEmpty(request.fileId)) {
                    throw new BadRequestException("No file-id specified in request");
                }
                key = new SessionConvertPassword(request.fileId);

                break;
            default:
                throw new BadRequestException("Unknown key type: " + request.keyType);
        }

        String newSessionId = sessionDao.createOrUpdate(request.session, key, request.value);
        doc.addElement("session").setText(newSessionId);
    }

}
