package ru.yandex.chemodan.app.docviewer.web.backend;

import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.DiskManager;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequestWithUid;
import ru.yandex.chemodan.app.docviewer.web.framework.AbstractXmlActionServlet;
import ru.yandex.chemodan.app.docviewer.web.framework.ActionParameter;
import ru.yandex.chemodan.app.docviewer.web.framework.WebSecurityManager;
import ru.yandex.chemodan.app.docviewer.web.framework.exception.BadRequestException;

/**
 * @author akirakozov
 */
public class ShareAction extends AbstractXmlActionServlet<ShareAction.ShareRequest> implements BackendServlet{

    public static class ShareRequest extends DocviewerRequestWithUid {
        @ActionParameter
        String url;
    }

    @Autowired
    private WebSecurityManager webSecurityManager;
    @Autowired
    private DiskManager diskManager;

    @Override
    public void execute(ShareRequest request, Document doc) {
        ActualUri uri = getActualUri(request);

        DocumentSourceInfo documentSourceInfo = getDocumentSourceInfo(request);
        DiskResourceId id = diskManager.getDiskResourceId(documentSourceInfo, uri).getOrThrow(
                () -> new BadRequestException("Uri doesn't correspond to disk resource"));
        String shortPublicUrl = diskManager.shareResourceAndGetShortUrl(
                request.uid, id);
        doc.addElement("short-url").addText(shortPublicUrl);
    }

    private DocumentSourceInfo getDocumentSourceInfo(ShareRequest request) {
        return DocumentSourceInfo.builder().originalUrl(request.url).uid(request.uid).build().withShowNda(request.showNda);
    }

    private ActualUri getActualUri(ShareRequest request) {
        return webSecurityManager.validateRightAndGetActualUri(getDocumentSourceInfo(request));
    }

    @Override
    public String getActionUrl() {
        return "/share";
    }

}
