package ru.yandex.chemodan.app.docviewer.web.backend;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.states.FileTooBigUserException;
import ru.yandex.chemodan.app.docviewer.web.backend.SourceInternalAction.SourceInternalRequest;
import ru.yandex.chemodan.app.docviewer.web.framework.ActionParameter;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class SourceInternalAction extends AbstractSourceAction<SourceInternalRequest> implements BackendServlet {
    private static final Logger logger = LoggerFactory.getLogger(SourceInternalAction.class);

    public static String buildDownloadFileUUID(String url, Option<String> pathInArchive) {
        return UrlUtils.urlEncode(url) + "&" + UrlUtils.urlEncode(pathInArchive.getOrElse(""));
    }


    public static class SourceInternalRequest extends AbstractSourceRequest {
        @ActionParameter("download-file-uuid")
        String docviewerDownloadFileUUID;

        private String url;
        private Option<String> pathInArchive = Option.empty();

        @Override
        Option<String> getSession() {
            return Option.empty();
        }

        @Override
        Option<String> getArchivePath() {
            parseUUID();
            return pathInArchive;
        }

        @Override
        Option<String> getUrl() {
            parseUUID();
            return StringUtils.notEmptyO(url);
        }

        @Override
        Option<String> getFileId() {
            return Option.empty();
        }

        private void parseUUID() {
            if (url != null) {
                return;
            }

            String[] split = StringUtils.split(docviewerDownloadFileUUID, "&");
            if (split == null || split.length == 0) {
                return;
            }

            url = UrlUtils.urlDecode(split[0]);
            if (split.length > 1) {
                pathInArchive = StringUtils.notEmptyO(UrlUtils.urlDecode(split[1]));
            }
        }
    }

    @Override
    public String getActionUrl() {
        return "/source-internal";
    }

    @Override
    protected void doGetImpl(HttpServletRequest req, SourceInternalRequest request, HttpServletResponse resp) {
        try {
            extractAndWriteResult(request, req, resp);
        } catch (FileTooBigUserException ftb) {
            logger.error("User requested too big file, actual: {}, limit: {}",
                    ftb.getActualLength(), ftb.getMaxLength());
            throw ftb;
        }

    }
}
