package ru.yandex.chemodan.app.docviewer.web.backend;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.dom4j.Document;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.utils.RuntimeMalformedURLException;
import ru.yandex.chemodan.app.docviewer.utils.RuntimeURISyntaxException;
import ru.yandex.chemodan.app.docviewer.web.framework.exception.BadRequestException;

/**
 * @author metal
 */
public class StartInternalAction extends StartAction {

    static final String PATH = "/start-internal";

    protected void execute(HttpServletRequest req, StartRequest request, Document doc, HttpServletResponse resp) {
        executeInner(request);
        doc.addElement("ok");
    }

    private void executeInner(StartRequest request) {
        try {
            getStateMachine().onStart(getDocumentSourceInfo(request), getActionUrl(),
                    Option.empty(), request.type,
                    request.session,  parseSkipableContentTypes(request.skipMimes),
                    getStartRequestTime(), true);

        } catch (RuntimeMalformedURLException | RuntimeURISyntaxException exc) {
            throw new BadRequestException("Specified URL '" + request.url + "' is incorrect");
        }
    }

    @Override
    public String getActionUrl() {
        return PATH;
    }
}
